<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$db = new SQLite3('a/.eggziedb.db');

$message = '';

// Consulta para buscar todas as revendas
$query_revenda = "
    SELECT id, usuario, registro
    FROM revenda
";

// Consulta para buscar todas as subrevendas
$query_subrevenda = "
    SELECT id, usuario, registro
    FROM sub_revenda
";

$results_revenda = $db->query($query_revenda);
$results_subrevenda = $db->query($query_subrevenda);

// Função para atualizar a data na coluna "registro"
function atualizarRegistro($db, $id, $nova_data) {
    $stmt = $db->prepare("UPDATE revenda SET registro = :nova_data WHERE id = :id");
    $stmt->bindValue(':nova_data', $nova_data, SQLITE3_TEXT);
    $stmt->bindValue(':id', $id, SQLITE3_INTEGER);
    $stmt->execute();
}

// Função para atualizar a data na coluna "registro" para a data fixa
function atualizarRegistroCadeado($db, $id) {
    $nova_data = '1992-10-10';
    $stmt = $db->prepare("UPDATE revenda SET registro = :nova_data WHERE id = :id");
    $stmt->bindValue(':nova_data', $nova_data, SQLITE3_TEXT);
    $stmt->bindValue(':id', $id, SQLITE3_INTEGER);
    $stmt->execute();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Verificando se a ação de renovação foi disparada
    if (isset($_POST['renovar'])) {
        $id = $_POST['id']; // Obtendo o ID da revenda ou subrevenda
        $nova_data = date('Y-m-d', strtotime('+30 days')); // Atualiza para 30 dias a partir de hoje
        // Verifica se é revenda ou subrevenda
        $tabela = $_POST['tabela']; 
        if ($tabela == 'revenda') {
            atualizarRegistro($db, $id, $nova_data);
        } else {
            // Atualizando na tabela sub_revenda
            $stmt = $db->prepare("UPDATE sub_revenda SET registro = :nova_data WHERE id = :id");
            $stmt->bindValue(':nova_data', $nova_data, SQLITE3_TEXT);
            $stmt->bindValue(':id', $id, SQLITE3_INTEGER);
            $stmt->execute();
        }
        $message = 'Data de registro renovada para 30 dias.';
    }

    // Verificando se a ação de bloqueio foi disparada
    if (isset($_POST['cadeado'])) {
        $id = $_POST['id']; // Obtendo o ID da revenda ou subrevenda
        // Verifica se é revenda ou subrevenda
        $tabela = $_POST['tabela']; 
        if ($tabela == 'revenda') {
            atualizarRegistroCadeado($db, $id);
        } else {
            // Atualizando na tabela sub_revenda
            $stmt = $db->prepare("UPDATE sub_revenda SET registro = :nova_data WHERE id = :id");
            $stmt->bindValue(':nova_data', '1992-10-10', SQLITE3_TEXT);
            $stmt->bindValue(':id', $id, SQLITE3_INTEGER);
            $stmt->execute();
        }
        $message = 'Data de registro atualizada para 1992-10-10.';
    }
}

include 'includes/header.php';
?>

<main role="main" class="container pt-4">
    <div class="row justify-content-center">
        <div id="main" class="col-12">
            <div class="text-center">
                <img src="fotodns.png" alt="Imagem de Migração DNS" class="img-fluid mx-auto d-block" style="max-width: 100px;" />
                <h1 class="h3 mb-3 text-gray-800">Revendas e Subrevendas</h1>
            </div>

            <?php if (!empty($message)) : ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $message; ?>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif; ?>

            <h2 class="mt-4" style="font-weight: bold; color: black;">Revendas</h2>

            <!-- Tabela de Revendas Responsiva -->
            <div class="table-responsive">
                <table class="table table-bordered mt-3">
                    <thead>
                        <tr>
                            <th style="font-weight: bold; color: black;">Revenda</th>
                            <th style="font-weight: bold; color: black;">Data de Registro</th>
                            <th style="font-weight: bold; color: black;">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $results_revenda->fetchArray(SQLITE3_ASSOC)) : ?>
                            <tr>
                                <td style="background-color: #28a745; color: white;"><?php echo htmlspecialchars($row['usuario']); ?></td>
                                <td style="background-color: #dc3545; color: white;"><?php echo htmlspecialchars($row['registro']); ?></td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <form method="POST" action="" style="display:inline-block;">
                                            <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                            <input type="hidden" name="tabela" value="revenda">
                                            <button type="submit" name="renovar" class="btn btn-success btn-sm" title="Renovar">
                                                <i class="fas fa-sync"></i> Renovar
                                            </button>
                                        </form>
                                        <form method="POST" action="" style="display:inline-block;">
                                            <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                            <input type="hidden" name="tabela" value="revenda">
                                            <button type="submit" name="cadeado" class="btn btn-secondary btn-sm" title="Bloquear">
                                                <i class="fas fa-lock"></i> Bloquear
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>

            <h2 class="mt-4" style="font-weight: bold; color: black;">Subrevendas</h2>

            <!-- Tabela de Subrevendas Responsiva -->
            <div class="table-responsive">
                <table class="table table-bordered mt-3">
                    <thead>
                        <tr>
                            <th style="font-weight: bold; color: black;">Subrevenda</th>
                            <th style="font-weight: bold; color: black;">Data de Registro</th>
                            <th style="font-weight: bold; color: black;">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $results_subrevenda->fetchArray(SQLITE3_ASSOC)) : ?>
                            <tr>
                                <td style="background-color: #28a745; color: white;"><?php echo htmlspecialchars($row['usuario']); ?></td>
                                <td style="background-color: #dc3545; color: white;"><?php echo htmlspecialchars($row['registro']); ?></td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <form method="POST" action="" style="display:inline-block;">
                                            <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                            <input type="hidden" name="tabela" value="sub_revenda">
                                            <button type="submit" name="renovar" class="btn btn-success btn-sm" title="Renovar">
                                                <i class="fas fa-sync"></i> Renovar
                                            </button>
                                        </form>
                                        <form method="POST" action="" style="display:inline-block;">
                                            <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                            <input type="hidden" name="tabela" value="sub_revenda">
                                            <button type="submit" name="cadeado" class="btn btn-secondary btn-sm" title="Bloquear">
                                                <i class="fas fa-lock"></i> Bloquear
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<?php include 'includes/footer.php'; ?>

<script src="https://kit.fontawesome.com/a076d05399.js"></script> <!-- Incluindo o FontAwesome -->
<script>
    setTimeout(function() {
        $('.alert').alert('close');
    }, 5000);
</script>

</body>
</html>
