<?php
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
$results_per_page = 20; // Defina o número desejado de itens por página

$db1 = new SQLite3('a/.eggziedb.db');

// Search functionality
$searchTerm = isset($_GET['search']) ? $_GET['search'] : '';
$searchQuery = '';
if (!empty($searchTerm)) {
    $searchQuery = "WHERE mac_address LIKE '%$searchTerm%' OR title LIKE '%$searchTerm%' OR username LIKE '%$searchTerm%'";
}

$result = $db1->query("SELECT COUNT(id) AS total FROM ibo $searchQuery");
$rownew = $result->fetchArray();
$totaleview = $rownew['total'];

$res1 = $db1->query("SELECT * FROM ibo $searchQuery ORDER BY id ASC");

if (isset($_GET['delete'])) {
    $ids_to_delete = explode(',', $_GET['delete']);
    foreach ($ids_to_delete as $id) {
        $db1->exec('DELETE FROM ibo WHERE id=' . $id);
    }
    header('Location: users.php');
    exit(); // Para garantir que o código pare de ser executado após o redirecionamento
}

include 'includes/header.php';

function getDeviceKey($mac_address) {
    // Garante que o MAC Address seja tratado em minúsculas
    $mac_address = strtolower($mac_address); 
    
    $fileContent = file_get_contents('a/device_keys.json');
    if ($fileContent === false) {
        return 'Erro ao ler o arquivo JSON.';
    }
    
    $deviceKeys = json_decode($fileContent, true);
    
    // Converte as chaves do arquivo JSON para minúsculas para comparação
    foreach ($deviceKeys as $key => $value) {
        // Converte a chave para minúsculas antes da comparação
        if (strtolower($key) === $mac_address) {
            return $value;
        }
    }
    
    return 'Não encontrado';
}

function saveDeviceKey($mac_address, $new_device_key) {
    $mac_address = strtolower($mac_address); // Garante que o MAC Address seja tratado em minúsculas
    
    // Leitura do arquivo JSON
    $fileContent = file_get_contents('a/device_keys.json');
    if ($fileContent === false) {
        return 'Erro ao ler o arquivo JSON.';
    }
    
    $deviceKeys = json_decode($fileContent, true);
    
    // Verifica se o MAC Address já existe no arquivo JSON
    if (isset($deviceKeys[$mac_address])) {
        return updateDeviceKey($mac_address, $new_device_key);  // Atualiza a chave existente
    } else {
        // Se não existir, cria uma nova entrada
        $deviceKeys[$mac_address] = $new_device_key;
        
        // Salva no arquivo JSON
        $result = file_put_contents('a/device_keys.json', json_encode($deviceKeys, JSON_PRETTY_PRINT));
        
        // Verifica se o arquivo foi salvo com sucesso
        if ($result === false) {
            return 'Erro ao salvar o arquivo JSON.';
        }
        
        return 'Nova chave de dispositivo adicionada com sucesso!';
    }
}

function updateDeviceKey($mac_address, $new_key) {
    $mac_address = strtolower($mac_address); 
    
    // Lê o conteúdo do arquivo JSON
    $fileContent = file_get_contents('a/device_keys.json');
    if ($fileContent === false) {
        return 'Erro ao ler o arquivo JSON.';
    }

    // Decodifica o conteúdo JSON
    $deviceKeys = json_decode($fileContent, true);
    
    // Variável para verificar se encontramos o MAC Address
    $found = false;
    
    // Itera sobre as chaves do JSON e compara com o MAC Address fornecido
    foreach ($deviceKeys as $key => $value) {
        // Converte a chave para minúsculas antes da comparação
        if (strtolower($key) === $mac_address) {
            // Atualiza a chave encontrada com a nova chave fornecida
            $deviceKeys[$key] = $new_key;
            $found = true;
            break; // Sai do loop após a atualização
        }
    }

    if ($found) {
        // Salva a atualização de volta no arquivo JSON
        $updatedContent = json_encode($deviceKeys, JSON_PRETTY_PRINT);
        file_put_contents('a/device_keys.json', $updatedContent);
        return 'Mensagem Atualizada com sucesso!';
    } else {
        return 'MAC Address não encontrado';
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['save_device_key'])) {
    $mac_address = $_POST['mac_address'];
    $new_device_key = $_POST['new_device_key'];

    if (!empty($mac_address) && !empty($new_device_key)) {
        echo "<script>alert('" . updateDeviceKey($mac_address, $new_device_key) . "');</script>";
    } else {
        echo "<script>alert('Por favor, insira todos os campos corretamente.');</script>";
    }
}
?>

<style>
    .pagination-gap {
        margin-left: 2px;
        margin-right: 2px;
        background-color: green;
        color: white;
        text-align: center;
        padding: 5px 10px;
    }

    .pagination-red {
        margin-left: 2px;
        margin-right: 2px;
        background-color: royalblue;
        color: white;
        text-align: center;
        padding: 5px 10px;
    }
</style>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

<main role="main" class="col-15 pt-4 px-5">
    <div id="main">
        <div class="row">
            <div class="col-lg-12">
                <div class="card border-left-primary shadow h-100 card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary2"><i class="fas fa-fw fa-user-plus"></i> Usuários</h6>
                    </div>
                    <div class="card-body">
                        <form method="get" class="mb-3">
                            <div class="form-group">
                                <div class="input-group">
                                    <input type="text" name="search" class="form-control" placeholder="Pesquise por MAC, Titulo, Username....">
                                    <div class="input-group-append">
                                        <button type="submit" class="btn btn-primary">Pesquisar</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <div class="form-group">
                            <div class="input-group">
                                <a href="./users_create.php" class="btn btn-primary btn-icon-split">
                                    <span class="icon text-white-50"><i class="fas fa-check"></i></span>
                                    <span class="text">Criar</span>
                                </a>
                                <button type="button" class="btn btn-danger ml-2" id="excluirSelecionados">Excluir Selecionados</button>
                            </div>
                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="table table-striped table-sm">
                                <thead class="text-primary">
                                    <tr>
                                        <th><input type="checkbox" id="selecionarTodos" onclick="selecionarTodos()"></th>
                                        <th>Título</th>
                                        <th>Mac Address</th>
                                        <th>Username</th>
                                        <th>Vendedor</th>
                                        <th>Validade</th>
                                        <th>DNS</th>
                                        <th>Extra</th>
                                        <th>Editar</th>
                                        <th>Mensagem</th> <!-- Coluna para o ícone de mensagem -->
                                        <th>Deletar</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while ($row1 = $res1->fetchArray()) { ?>
                                        <tr>
                                            <?php
                                            $users_id = $row1['id'];
                                            $user_mac = $row1['mac_address'];
                                            $user_username = $row1['username'];
                                            $user_seller = $row1['seller'];
                                            $user_expire_date = $row1['expire_date'];
                                            $user_url = $row1['url'];
                                            $user_title = $row1['title'];
                                            $device_key = getDeviceKey($user_mac); // Busca o device_key
                                            ?>
                                            <td><input type="checkbox" name="delete_check[]" value="<?php echo $users_id; ?>"></td>
                                            <td><?php echo $user_title; ?></td>
                                            <td><?php echo $user_mac; ?></td>
                                            <td><?php echo $user_username; ?></td>
                                            <td><?php echo $user_seller; ?></td>
                                            <td><?php echo $user_expire_date; ?></td>
                                            <td><?php echo $user_url; ?></td>
                                            <td><?php echo $row1['extra']; ?></td>
                                            <td>
                                                <a class="btn btn-icon" href="./users_update.php?update=<?php echo $users_id; ?>">
                                                    <span class="icon text-white-50">
                                                        <i class="fa fa-edit" style="font-size:24px;color:blue"></i>
                                                    </span>
                                                </a>
                                            </td>
                                            <!-- Ícone de mensagem que exibe o device_key -->
                                            <td>
                                                <button type="button" class="btn btn-icon" title="Editar Device Key" data-bs-toggle="modal" data-bs-target="#messageModal" data-mac-address="<?php echo $user_mac; ?>" data-device-key="<?php echo $device_key; ?>">
                                                    <span class="icon text-white-50">
                                                        <i class="fa fa-comment" style="font-size:24px;color:green"></i>
                                                    </span>
                                                </button>
                                            </td>
                                            <td>
                                                <a class="btn btn-icon delete-btn" href="./users.php?delete=<?php echo $users_id; ?>" onclick="return confirm('Tem certeza de que deseja excluir este item?');">
                                                    <span class="icon text-white-50"><i class="fa fa-ban" style="font-size:24px;color:red"></i></span>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                            <?php include 'includes/footer.php'; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<!-- Modal -->
<div class="modal fade" id="messageModal" tabindex="-1" aria-labelledby="messageModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="messageModalLabel">Mensagem</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p id="deviceKeyContent">Carregando...</p>
                <form method="POST">
                    <div>
                        <label for="newDeviceKey">Nova Mensagem:</label>
                        <input type="text" id="newDeviceKey" name="new_device_key" class="form-control">
                        <input type="hidden" id="macAddress" name="mac_address">
                        <button type="submit" name="save_device_key" class="btn btn-primary mt-2">Salvar</button>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<script>
    document.querySelectorAll('.fa-comment').forEach(function (icon) {
    icon.addEventListener('click', function (event) {
        event.preventDefault(); // Impede o redirecionamento

        // Pega o mac_address e device_key
        var macAddress = icon.closest('tr').querySelector('td:nth-child(3)').innerText;
        var deviceKey = icon.closest('button').getAttribute('data-device-key');

        // Exibe o device_key no modal
        document.getElementById('deviceKeyContent').innerText = 'Mensagem Anterior: ' + (deviceKey || 'Não encontrado');
        document.getElementById('macAddress').value = macAddress; // Define o mac_address no campo oculto
        // Exibe o modal
        new bootstrap.Modal(document.getElementById('messageModal')).show();
    });
});

</script>
