<?php
// Verificar se a sessão foi iniciada
if (session_status() == PHP_SESSION_NONE) {
    session_start(); // Inicia a sessão somente se ela ainda não tiver sido iniciada
}

ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

// Verifique se o ID do usuário na sessão existe
if (!isset($_SESSION['id'])) {
    die('Sessão expirada ou usuário não autenticado.');
}

// Verifique se o nome do reseller está definido na sessão (foi alterado de seller_name para seller_name)
if (!isset($_SESSION['seller_name'])) {
    die('Nome do reseller não definido na sessão.');
}

// Obter o nome do reseller logado
$seller_name = $_SESSION['seller_name']; // Aqui o nome do reseller vem da sessão

$db = new SQLite3(__DIR__ . '/../a/.eggziedb.db');

// Variáveis de erro e sucesso
$message = '';
$error = '';

// Buscar dados se o formulário for enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'];
    $novo_mac = $_POST['novo_mac'];
    $seller_name = $_POST['seller_name'];
    
    // Verifica se o reseller tem MACs disponíveis
    $check_macs = $db->querySingle("SELECT macs FROM revenda WHERE seller_name = '$seller_name'");
    if ($check_macs > 0) {
        // Atualiza o MAC Address
        $update_query = "UPDATE clientes SET mac_address = '$novo_mac' WHERE id = '$id'";
        
        if ($db->exec($update_query)) {
            // Atualiza a quantidade de MACs do reseller
            $db->exec("UPDATE revenda SET macs = macs - 1 WHERE seller_name = '$seller_name'");
            
            echo 'Dados atualizados com sucesso!';
        } else {
            echo 'Erro ao atualizar os dados.';
        }
    } else {
        echo 'Você não tem mais MACs disponíveis para atualizar.';
    }
} else {
    echo 'Requisição inválida.';
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update'])) {
    $mac_address = strtoupper(trim($db->escapeString($_POST['mac_address']))); // Converter para MAIÚSCULAS
    $username = $db->escapeString($_POST['username']);
    $password = $db->escapeString($_POST['password']);
    $expire_date = $db->escapeString($_POST['expire_date']);
    $url = $db->escapeString($_POST['url']);
    $title = $db->escapeString($_POST['title']);
    $seller = $db->escapeString($_POST['seller']);

    // Verificar se o MAC Address já existe antes de atualizar
    $check_query = $db->query("SELECT COUNT(*) as count FROM ibo WHERE UPPER(mac_address) = UPPER('$mac_address')");
    $result = $check_query->fetchArray();

    if ($result['count'] > 0) {
        // Atualizando o banco de dados e forçando maiúsculas no SQL
        $update_query = "UPDATE ibo SET 
                        mac_address = UPPER('$mac_address'), 
                        username = '$username', 
                        password = '$password', 
                        expire_date = '$expire_date', 
                        url = '$url', 
                        title = '$title', 
                        seller = '$seller' 
                        WHERE UPPER(mac_address) = UPPER('$mac_address')";

        if ($db->exec($update_query)) {
            $message = 'Dados atualizados com sucesso!';
        } else {
            $error = 'Erro ao atualizar os dados. Verifique as informações.';
        }
    } else {
        $error = 'MAC Address não encontrado no banco de dados.';
    }
}


include __DIR__ . '/../includes/header2.php';
?>

<main role="main" class="container pt-4">
    <div class="row justify-content-center">
        <div id="main" class="col-12">
            <img src="fotodns.png" alt="Imagem de Migração DNS" class="img-fluid mx-auto d-block" style="max-width: 100px;" />

            <!-- Mensagens de Sucesso ou Erro -->
            <?php if (!empty($message)) : ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $message; ?>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif; ?>
            <?php if (!empty($error)) : ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo $error; ?>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif; ?>

            <h1 class="h3 mb-3 text-gray-800 text-center">Atualizar Dados do MAC Address</h1>
            
            <form method="POST" action="">
                <!-- Campo de busca MAC Address -->
                <div class="form-group">
                    <label for="mac_address">Digite o MAC Address</label>
                    <input type="text" class="form-control" id="mac_address" name="mac_address" value="<?php echo isset($mac_address) ? $mac_address : ''; ?>" required>
                </div>
                <button type="submit" class="btn btn-primary">Buscar</button>
            </form>

            <?php if (isset($mac_address_found) && $mac_address_found) : ?>
                <hr>

                <!-- Formulário para editar os dados -->
                <h3>Editar Dados</h3>
                <form method="POST" action="">
                    <input type="hidden" name="mac_address" value="<?php echo $mac_address; ?>">

                    <div class="form-group">
                        <label for="username">Username</label>
                        <input type="text" class="form-control" id="username" name="username" value="<?php echo $username; ?>" required>
                    </div>
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="text" class="form-control" id="password" name="password" value="<?php echo $password; ?>" required>
                    </div>
                    <div class="form-group">
                        <label for="expire_date">Expire Date</label>
                        <?php
                        // Calcular a data de expiração para 1 ano após o dia atual
                        $expire_date = date('Y-m-d', strtotime('+1 year'));
                        ?>
                        <input type="text" class="form-control" id="expire_date" name="expire_date" value="<?php echo $expire_date; ?>" readonly>
                    </div>
                    <div class="form-group">
                        <label for="url">URL</label>
                        <input type="text" class="form-control" id="url" name="url" value="<?php echo $url; ?>" required>
                    </div>
                    <div class="form-group">
                        <label for="title">Title</label>
                        <input type="text" class="form-control" id="title" name="title" value="<?php echo $title; ?>" required>
                    </div>
                    <div class="form-group">
                        <label for="seller">Digite Seu Login:</label>
                        <input type="text" class="form-control" id="seller" name="seller" value="<?php echo $seller; ?>" required>
                    </div>

                    <button type="submit" name="update" class="btn btn-success">Atualizar Dados</button>
                </form>
            <?php endif; ?>
        </div>
    </div>
</main>

<?php
include __DIR__ . '/../includes/footer2.php';
?>

<script>
    // Script para fechar a mensagem de sucesso após alguns segundos
    setTimeout(function() {
        $('.alert').alert('close');
    }, 5000);
</script>

</body>
</html>
